<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Provider extends Model 
{

    protected $table = 'providers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone1', 'phone2', 'created_by', 'updated_by');

    public function stocks()
    {
        return $this->hasMany('App\Models\Store', 'provider_id');
    }

}